/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.util.ArrayList;
import java.util.List;
import org.python.antlr.AST;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.VisitorIF;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.tree.CommonTree;
import org.python.core.PyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonTree
extends AST {
    public boolean from_future_checked = false;
    private int charStartIndex = -1;
    private int charStopIndex = -1;
    private CommonTree node;
    private PythonTree parent;
    protected List<PythonTree> children;

    public PythonTree() {
        this.node = new CommonTree();
    }

    public PythonTree(PyType pyType) {
        super(pyType);
        this.node = new CommonTree();
    }

    public PythonTree(Token token) {
        this.node = new CommonTree(token);
    }

    public PythonTree(int n, Token token) {
        CommonToken commonToken = new CommonToken(n, token.getText());
        commonToken.setLine(token.getLine());
        commonToken.setTokenIndex(token.getTokenIndex());
        commonToken.setCharPositionInLine(token.getCharPositionInLine());
        commonToken.setChannel(token.getChannel());
        commonToken.setStartIndex(((CommonToken)token).getStartIndex());
        commonToken.setStopIndex(((CommonToken)token).getStopIndex());
        this.node = new CommonTree(commonToken);
    }

    public PythonTree(PythonTree pythonTree) {
        this.node = new CommonTree(pythonTree.getNode());
        this.charStartIndex = pythonTree.getCharStartIndex();
        this.charStopIndex = pythonTree.getCharStopIndex();
    }

    public CommonTree getNode() {
        return this.node;
    }

    public Token getToken() {
        return this.node.getToken();
    }

    public PythonTree dupNode() {
        return new PythonTree(this);
    }

    public boolean isNil() {
        return this.node.isNil();
    }

    public int getAntlrType() {
        return this.node.getType();
    }

    public String getText() {
        return this.node.getText();
    }

    public int getLine() {
        if (this.node.getToken() == null || this.node.getToken().getLine() == 0) {
            if (this.getChildCount() > 0) {
                return this.getChild(0).getLine();
            }
            return 1;
        }
        return this.node.getToken().getLine();
    }

    public int getCharPositionInLine() {
        Token token = this.node.getToken();
        if (token == null || token.getCharPositionInLine() == -1) {
            if (this.getChildCount() > 0) {
                return this.getChild(0).getCharPositionInLine();
            }
            return 0;
        }
        if (token != null && token.getCharPositionInLine() == -2) {
            return -1;
        }
        return token.getCharPositionInLine();
    }

    public int getTokenStartIndex() {
        return this.node.getTokenStartIndex();
    }

    public void setTokenStartIndex(int n) {
        this.node.setTokenStartIndex(n);
    }

    public int getTokenStopIndex() {
        return this.node.getTokenStopIndex();
    }

    public void setTokenStopIndex(int n) {
        this.node.setTokenStopIndex(n);
    }

    public int getCharStartIndex() {
        if (this.charStartIndex == -1 && this.node.getToken() != null) {
            return ((CommonToken)this.node.getToken()).getStartIndex();
        }
        return this.charStartIndex;
    }

    public void setCharStartIndex(int n) {
        this.charStartIndex = n;
    }

    public int getCharStopIndex() {
        if (this.charStopIndex == -1 && this.node.getToken() != null) {
            return ((CommonToken)this.node.getToken()).getStopIndex() + 1;
        }
        return this.charStopIndex;
    }

    public void setCharStopIndex(int n) {
        this.charStopIndex = n;
    }

    public int getChildIndex() {
        return this.node.getChildIndex();
    }

    public PythonTree getParent() {
        return this.parent;
    }

    public void setParent(PythonTree pythonTree) {
        this.parent = pythonTree;
    }

    public void setChildIndex(int n) {
        this.node.setChildIndex(n);
    }

    public static String dottedNameListToString(List<Name> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Name name = list.get(i);
            String string = name.getInternalId();
            if (string == null) continue;
            if (!".".equals(string)) {
                bl = false;
            }
            stringBuilder.append(string);
            if (i >= n - 1 || bl) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        if (this.isNil()) {
            return "None";
        }
        if (this.getAntlrType() == 0) {
            return "<errornode>";
        }
        if (this.node.getToken() == null) {
            return null;
        }
        return this.node.getToken().getText() + "(" + this.getLine() + "," + this.getCharPositionInLine() + ")";
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isNil()) {
            stringBuffer.append("(");
            stringBuffer.append(this.toString());
            stringBuffer.append(' ');
        }
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            PythonTree pythonTree = this.children.get(i);
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(pythonTree.toStringTree());
        }
        if (!this.isNil()) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    protected String dumpThis(String string) {
        return string;
    }

    protected String dumpThis(Object object) {
        if (object instanceof PythonTree) {
            return ((PythonTree)object).toStringTree();
        }
        return String.valueOf(object);
    }

    protected String dumpThis(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.dumpThis(objectArray[i]));
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public <R> R accept(VisitorIF<R> visitorIF) throws Exception {
        throw new RuntimeException("Unexpected node: " + this);
    }

    public void traverse(VisitorIF<?> visitorIF) throws Exception {
        throw new RuntimeException("Cannot traverse node: " + this);
    }

    public PythonTree getChild(int n) {
        if (this.children == null || n >= this.children.size()) {
            return null;
        }
        return this.children.get(n);
    }

    public List<PythonTree> getChildren() {
        return this.children;
    }

    public PythonTree getFirstChildWithType(int n) {
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            PythonTree pythonTree = this.children.get(i);
            if (pythonTree.getAntlrType() != n) continue;
            return pythonTree;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(PythonTree pythonTree) {
        if (pythonTree == null) {
            return;
        }
        PythonTree pythonTree2 = pythonTree;
        if (pythonTree2.isNil()) {
            if (this.children != null && this.children == pythonTree2.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (pythonTree2.children != null) {
                if (this.children != null) {
                    int n = pythonTree2.children.size();
                    for (int i = 0; i < n; ++i) {
                        PythonTree pythonTree3 = pythonTree2.children.get(i);
                        this.children.add(pythonTree3);
                        pythonTree3.setParent(this);
                        pythonTree3.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = pythonTree2.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(pythonTree);
            pythonTree2.setParent(this);
            pythonTree2.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List<PythonTree> list) {
        for (int i = 0; i < list.size(); ++i) {
            PythonTree pythonTree = list.get(i);
            this.addChild(pythonTree);
        }
    }

    public void setChild(int n, PythonTree pythonTree) {
        if (pythonTree == null) {
            return;
        }
        if (pythonTree.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(n, pythonTree);
        pythonTree.setParent(this);
        pythonTree.setChildIndex(n);
    }

    public Object deleteChild(int n) {
        if (this.children == null) {
            return null;
        }
        PythonTree pythonTree = this.children.remove(n);
        this.freshenParentAndChildIndexes(n);
        return pythonTree;
    }

    public void replaceChildren(int n, int n2, Object object) {
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int n3 = n2 - n + 1;
        PythonTree pythonTree = (PythonTree)object;
        List<PythonTree> list = null;
        if (pythonTree.isNil()) {
            list = pythonTree.children;
        } else {
            list = new ArrayList<PythonTree>(1);
            list.add(pythonTree);
        }
        int n4 = list.size();
        int n5 = list.size();
        int n6 = n3 - n4;
        if (n6 == 0) {
            int n7 = 0;
            for (int i = n; i <= n2; ++i) {
                PythonTree pythonTree2 = list.get(n7);
                this.children.set(i, pythonTree2);
                pythonTree2.setParent(this);
                pythonTree2.setChildIndex(i);
                ++n7;
            }
        } else if (n6 > 0) {
            int n8;
            for (n8 = 0; n8 < n5; ++n8) {
                this.children.set(n + n8, list.get(n8));
            }
            for (int i = n8 = n + n5; i <= n2; ++i) {
                PythonTree pythonTree3 = this.children.remove(n8);
            }
            this.freshenParentAndChildIndexes(n);
        } else {
            int n9;
            for (n9 = 0; n9 < n3; ++n9) {
                this.children.set(n + n9, list.get(n9));
            }
            n9 = n4 - n3;
            for (int i = n3; i < n4; ++i) {
                this.children.add(n + i, list.get(i));
            }
            this.freshenParentAndChildIndexes(n);
        }
    }

    protected List<PythonTree> createChildrenList() {
        return new ArrayList<PythonTree>();
    }

    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int n) {
        int n2 = this.getChildCount();
        for (int i = n; i < n2; ++i) {
            PythonTree pythonTree = this.getChild(i);
            pythonTree.setChildIndex(i);
            pythonTree.setParent(this);
        }
    }
}

